#include <iostream>
#include <fstream>
#include <cmath>
#include <cstring>
#include <stdlib.h>
#include <ctime>

// needed to make vrp_pp objects known to the compiler
#include "vrp_pp.h"

// needed to inform the compiler which external software can be expected to be installed
#include "vrp_pp_extern.h"

using namespace std;

int main(int argc, char** argv)
{

    // try to read existing command line options and store them in the configuration object
	struct VRP_PP_CONFIG CONFIG;
    CONFIG.weigthType = VRP_PP_ARC_WEIGHT::CUSTOM;

    for (int k = 0; k < argc; k++)
	{
		if (strcmp(argv[k], "-p") == 0)
		{
			// we are talking about the xml-scenario file
			// go to the submitted value itself
			k++;
			// save the submitted value
			CONFIG.FILE = argv[k];
		}
	}
    // declare a pointer to a problem object
    class VRP_PP_PROBLEM *prob;

    // open the xml-file and store scenario information in the problem-object
    prob = new class VRP_PP_PROBLEM(CONFIG.FILE);

    // print the data to the screen
    prob->print();

    // dismantle the reservations of memory
    delete prob;

    return 0;
}
