#pragma once
#include <Game.h>
#include <vector>
#include <string>
#include <fstream>
#include <Replayer.h>
#include <memory>

class ReplayGame : public Game {
    std::unique_ptr<Game> origGame;
    std::ifstream recording;
    struct Record {
        int player;
        std::string board;
        std::string move;
    };
    std::vector<Record> records;
    std::vector<Record>::iterator curRecord;
    std::vector<std::vector<std::string>> replayMoves;
    void fetchTurns(Game::create_func func);
public:
    ReplayGame(Game::create_func func, std::string file);

    //Things we directly get from the replay
    std::string name() const override { return "Replay for " + origGame->name(); }
    std::string playerName(int number) const override { return origGame->playerName(number); }
    void renderBoard() const override { origGame->renderBoard(); }
    void expectedFormat() const override { origGame->expectedFormat(); }

    std::tuple<Game::MoveResult, std::string> move(const std::string& move) override;

    //The actual logic, fed from the record file
    unsigned currentPlayer() const override;
    std::string serialize() const override;

    std::vector<std::unique_ptr<RePlayer>> players();
};
