#pragma once

#include <string>

#include <cstddef>

enum ExitReason {
    EXIT = 0, //Player exited
    WIN = 1, //Player won
    DRAW = 2,
    CRASH = 3,  //Player crashed
    INVALID_MOVE = 4,
    EXEC_FAILED = 5,
    INTERNAL_ERROR = 6, //Something went wrong in MCP
    RESOURCES_EXCEEDED = 7,
    //Reasons 8-15 are user specified
};

static const size_t READ = 0;
static const size_t WRITE = 1;

static const int INPUT_FD = 3;
static const int OUTPUT_FD = 4;

