#pragma once

#include <sys/resource.h> //rlim_t
#include <string>
#include <Player.h>
#include <csignal>
#include <list>
#include <map>
#include <functional>
#include <memory>
#include <Timeout.h>

class ProcessPlayer : public Player {
    static std::list<ProcessPlayer*> players;
    static ProcessPlayer* currentPlayer;

    std::chrono::microseconds softTime, hardTime;
    enum class TimeoutState { None, Soft, Hard } state;
    std::string binName;

    int from_player, to_player;
    int pid;
    int index;
    bool terminated;

    void stop();
    void resume();
    [[noreturn]] void terminate(ExitReason reason,const std::string& msg) const;

    std::shared_ptr<Timeout> softTimeout, hardTimeout;

    [[noreturn]] static void sigChild(siginfo_t*);
public:
    static rlim_t softMem, hardMem;

    ProcessPlayer(const ProcessPlayer&) = delete;
    explicit ProcessPlayer(std::string binary,
                           std::chrono::microseconds softTime,
                           std::chrono::microseconds hardTime);
    ~ProcessPlayer() override;

    virtual Player& operator<<(std::string state) override;
    virtual const Player& operator>>(std::string& move) override;
};
