#pragma once

#include <SignalHandler.h>

#include <chrono>
#include <functional>
#include <memory>
#include <sys/signal.h>

class Timeout {
    Timeout(std::chrono::microseconds time, std::function<void(void)> handler);
    Timeout(const Timeout&) = delete;
    Timeout& operator=(const Timeout&) = delete;
    static SignalHandler alarm_;

    static void programNext();

    using Clock = std::chrono::steady_clock;
    std::function<void(void)> _handler;

public:
    Clock::time_point absoluteTimeout;
    static void sigAlarm(siginfo_t*);
    static std::shared_ptr<Timeout> programTimeout(std::chrono::microseconds time,
                                            std::function<void(void)> handler);
};

