# General

The code archive you received includes a Makefile to compile everything.
The command 'make help' tells you about the supported build targets. A
plain 'make' will compile everything.

Once compiled, you get three binaries:

- The Master Control Program (MCP) allows two computer programs to
  play against each other. The MCP orchestrates the game by sending
  the current game state to the players and receiving their moves.
  The MCP enforces these rules and makes sure the players behave.
- A keyboard player, which allows you to play the game yourself using
  keyboard input. Run 'make demo' to start up a game with two of these
  players.
- An empty file 'my_player.cc' where you should develop your game
  playing algorithm. Look at the keyboard player to learn how you receive
  the game state from the MCP and how to send your own move back. You
  may copy code from the keyboard player and all other source files, if
  you like. You can test your player as black or white against the
  keyboard player via 'make black' or 'make white', respectively.

  Please note that your player is NOT allowed to use the shared library
  game.so in any way, because it contains the game logic.


The official check whether you pass the assignment and also the
tournament is performed under a time and memory limit for your
player. You may use 1GB of memory and up to 60 seconds of think time
for one move (multiple threads are allowed, 'fork()' is not). These
limits are enforced by the MCP. You can test your player under these
conditions using 'make fight'.

If you implement a long-running algorithm in your player, you may
react to the SIGXCPU signal. The MCP sends this signal when the 60
second think timer has expired. If you react to this signal, you get
one extra second to report your move to the MCP before it SIGKILLs
you.

To test your player with a specific board, you can specify the board
state by using 'mcp -i <state>'.


# Nine Men's Morris

Your assignment is to develop a computer player for the Nine Men's Morris game.
The code archive you get includes everything you need to get started. It should
compile and run on most Linux distributions and on Mac OS X, although we only
officially support the Ubuntu configuration in the computer pool. If you want
to work on your own machine, you need a reasonably modern C++ compiler and
environment with C++14 and UNIX 03 support. With gcc or LLVM's clang you should
be fine.

The game rules for Nine Men's Morris can be found in Wikipedia:
http://en.wikipedia.org/wiki/Nine_Men%27s_Morris
http://de.wikipedia.org/wiki/M%C3%BChle_(Spiel)

Since some of the rules are vague, here are some clarifications which are
mandatory within this assignment and the tournament:
* If you have a mill, you may remove one of your opponent's pieces from the
  board. If all of your opponent's pieces are part of a formed mill, you may
  remove any of those pieces. Otherwise, you may only remove pieces that are
  not part of a formed mill.
* Even if you close two mills in one move, you may only remove one piece.
* Once you are reduced to three pieces, your pieces may fly. This means you
  can move them to any empty spot on the board.
* The game ends in a draw if the current game state already appeared earlier.
* The game ends with the opposing player winning if the current player is
  unable to make a valid move.

The game state is represented as follows:

The first character signifies the current player (0 or 1), followed by a space.
The third and fifth character, separated by a space and followed by a newline,
signify the remaining pieces that can be placed on the board by players 0 and
1, respectively.

The last part are 24 characters, each corresponding to a field of the board.
Only the characters 0, 1, and . (dot) are allowed and have the following
meaning:
- 0 corresponds to a field occupied by one of player 0s pieces
- 1 corresponds to a field occupied by one of player 1s pieces
- . (dot) corresponds to an empty field.

Moves consist of three characters:

The first character specifies the field from which your piece is removed, or a
space or dot, if you place a new piece on the board.

The second character specifies the field on which your piece is moved or
placed.

The third character specifies which of your opponents pieces you want to
remove, if you have a mill. If this is not appropriate, you have to put a space
or a dot here.

