#include <iostream>
#include <sstream>
#include <string>
#include <vector>

#include <cassert>

#include <unistd.h> //read

const int MCP_INPUT  = 3;
const int MCP_OUTPUT = 4;
const int BUF_SIZE   = 20;

[[noreturn]] static void failout(const std::string& msg) {
    std::cerr << msg << std::endl;
    exit(1);
}

static std::string read_board() {
    char buf[BUF_SIZE] = {};
    std::stringstream ss;
    while (true) {
        auto bytes_read = read(MCP_INPUT, buf, BUF_SIZE-1);
        if (bytes_read <= 0)
            failout("Error reading input from MCP");

        //Is it the end?
        if (buf[bytes_read - 1] == '\n') {
            buf[bytes_read - 1] = '\0';
            break;
        }
        buf[bytes_read] = '\0';
        ss << buf;
    }
    ss << buf;
    return ss.str();
}

static void write_move(const std::string& move) {
    auto l = move.length();
    auto pos = 0u;
    while (pos < l) {
        auto bytes_written = write(MCP_OUTPUT, move.c_str() + pos, l - pos);
        if (bytes_written < 0)
            failout("Error writing to MCP");
        pos += bytes_written;
    }
}

int main() {
    while (std::cin.good() && !std::cin.eof() && std::cout.good()) {
        auto board = read_board();
        std::cout << "Your Move: ";
        std::string kbd_in;
        std::getline(std::cin, kbd_in);
        std::cout << std::endl;
        write_move(kbd_in + "\n");
    }
}
