#pragma once

#include <functional>
#include <map>
#include <csignal>

class SignalHandler {

    struct Handler {
        int signum;
        bool ignore;
        std::function<void(siginfo_t*)> handler;
    };
    Handler _handler;
    static std::multimap<int,Handler*> allHandlers;
    static void genericHandler(int signum, siginfo_t *si, void*);

public:
    SignalHandler(int signum, 
                  std::function<void(siginfo_t*)> handler, 
                  int flags = 0);
    virtual ~SignalHandler();

    SignalHandler(const SignalHandler&) = delete;
    SignalHandler& operator=(const SignalHandler&) = delete;

    static void ignoreSignal(int signum);

    void enableHandler(bool value = true);
};
