clear all;close all;clc;

%% Loading the data

ecgData=importdata('ecgData.txt');
filteredData=importdata('filtered_ecg.txt');

%the sampling rate of the signal is 1000 Hz
Fs=1000;

%calculate the signal energy and the threshold
signalEnergy=filteredData.^2;
threshold=max(signalEnergy)/3;

%use the implemented function to detect the peaks
[peaks] = ecgRPeakDetection(filteredData,Fs,threshold);

%plot the ecg data along with detected peaks
figure(1),hold on
plot(ecgData,'LineWidth',2)
plot(ecgData.*peaks,'r','LineWidth',2)
ylim([0.9*min(ecgData) 1.1*max(ecgData)]);


%% real-time setup

figure(2),hold on
figure(2),ylim([0.9*min(ecgData) 1.1*max(ecgData)]);
figure(2),xlim([0 10000]);
xAxis=1:1000;

%running the algorithm to receive and detect the peaks in every
%100ms-segments of the data, this procedure runs for 100 times 
%since we have 10000 data points in our signal data

for i=1:100
    
    %read the data for 100ms-segments of the data
    windowData=filteredData((i-1)*100+1:i*100);
    
    %detect the peaks
    [peaks] = ecgRPeakDetection(windowData,Fs,threshold);
    
    %update the plot of the signal data in each step and show the peaks
    %where need
    xAxis=(i-1)*100+1:i*100;
    
    figure(2),plot(xAxis,ecgData((i-1)*100+1:i*100),'LineWidth',2);
    figure(2),plot(xAxis,ecgData((i-1)*100+1:i*100).*peaks,'r','LineWidth',2)
    
    %play the beep sound in case we have a heart-beat in that segment
    if(sum(peaks)>0)
        beep
    end
    
    %wait for 100 ms to make the system look like real-time
    pause(0.1);
    
end